<?php

namespace Asics\Verifone\Observer;

use Exception;
use Magento\Checkout\Model\Session;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Sales\Model\Order;
use Asics\Verifone\Helper\VerifoneRewrite as VerifoneHelper;
use Verifone\Hosted\Model\Verifone;
use Psr\Log\LoggerInterface;
use Asics\Verifone\Helper\Configuration;

class PreDispatchCheckoutObserver implements ObserverInterface
{
    const STATUS_PENDING = 'pending';
    const PAYMENT_TYPE_IFRAME = 'iframe';

    /**
     * @var Configuration
     */
    protected $_configuration;

    /**
     * @var Session
     */
    protected $checkoutSession;

    /**
     * @var LoggerInterface
     */
    protected $logger;

    /**
     * PreDispatchCheckoutObserver constructor.
     * 
     * @param Configuration $configuration
     * @param Session $checkoutSession
     * @param VerifoneHelper $checkoutHelper
     * @param LoggerInterface $logger
     */
    public function __construct(
        Configuration $configuration,
        Session $checkoutSession,
        private readonly VerifoneHelper $checkoutHelper,
        LoggerInterface $logger
    ) {
        $this->_configuration = $configuration;
        $this->checkoutSession = $checkoutSession;
        $this->logger = $logger;
    }

    /**
     * Process the event
     *
     * @param Observer $observer
     * @return void
     * @throws Exception
     */
    public function execute(Observer $observer)
    {
        try {
            if ($this->getPaymentSettings('active')
                && $this->getPaymentSettings('account_settings/order_before_redirect')
            ) {
                $lastRealOrder = $this->checkoutSession->getLastRealOrder();
                $payment = $lastRealOrder->getPayment();
                if (!isset($payment) || $payment === null || $payment->getMethod() !== Verifone::CODE) {
                    return;
                }
                $info = $payment->getAdditionalInformation();
                if (isset($info) && !empty($info['verifone_order_number'])) {
                    return;
                }

                if ($lastRealOrder->getState() === Order::STATE_NEW
                    && $lastRealOrder->getStatus() === self::STATUS_PENDING) {
                    $this->checkoutHelper->cancelCurrentOrder('');
                    $this->checkoutSession->restoreQuote();
                }
            }
        } catch(Exception $e) {
            $this->logger->critical(__METHOD__ . "  " . "\n" . $e->getMessage() . $e->getTraceAsString());
        }
    }

    /**
     * @param $path
     * @return mixed
     */
    public function getPaymentSettings($path)
    {
        return $this->_configuration->_getVerifoneStoreConfig($path);
    }
}
