define([
    'jquery',
], function ($) {
    'use strict';

    return function (config, element) {
        let videoEl = element.find('video.banner-video');        
        if (videoEl.length) {
            let videoSources = videoEl.find('source.pb-banner__bannervideo');
            if (videoSources.length) {
                let windowWidth = window.innerWidth || $(window).width();
                if (windowWidth >= 769) {
                    let desktopSource = videoEl.find('source.pb-banner__bannervideo--desktop');
                    if (desktopSource.length) {
                        videoEl.show();
                    } else {
                        videoEl.hide();
                    }
                } else {
                    let mobileSource = videoEl.find('source.pb-banner__bannervideo--mobile');
                    if (mobileSource.length) {
                        videoEl.show();
                    } else {
                        videoEl.hide();
                    }
                }                
            } else {
                videoEl.hide();
            }
        }
    };
});
