<?php

namespace BrittainWynyard\Sales\Model\Order\Email\Sender;

use Magento\Sales\Model\Order;

class OrderSender extends \Magento\Sales\Model\Order\Email\Sender\OrderSender
{
    protected $orderFailedStatus = [
        'paymentexpress_failed',
        'windcave_failed'
    ];

    public function send(Order $order, $forceSyncMode = false)
    {
        if (!in_array($order->getStatus(), $this->orderFailedStatus)) {
            return parent::send($order, $forceSyncMode);
        }

        return false;
    }
}
