<?php
namespace Overdose\Afterpay\Block\Catalog;

use Magento\Framework\View\Element\Template;
use Magento\Catalog\Model\Product as Product;
use Magento\Framework\Registry as Registry;
use Magento\Directory\Model\Currency as Currency;
use Afterpay\Afterpay\Model\Config as AfterpayConfig;
use Magento\Framework\Component\ComponentRegistrar as ComponentRegistrar;

class Installments extends Template
{
    protected $registry;
    protected $currency;
    protected $afterpayConfig;
    protected $componentRegistrar;

    /**
     * Installments constructor.
     * @param Template\Context $context
     * @param Registry $registry
     * @param Currency $currency
     * @param AfterpayConfig $afterpayConfig
     * @param ComponentRegistrar $componentRegistrar
     * @param array $data
     */
    public function __construct(
        Template\Context $context,
        Registry $registry,
        Currency $currency,
        AfterpayConfig $afterpayConfig,
        ComponentRegistrar $componentRegistrar,
        array $data
    ) {
        $this->registry = $registry;
        $this->currency = $currency;
        $this->afterpayConfig = $afterpayConfig;
        $this->componentRegistrar = $componentRegistrar;
        parent::__construct($context, $data);
    }

    /**
     * @return bool
     */
    protected function _getPaymentIsActive()
    {
        return $this->afterpayConfig->getIsPaymentActive();
    }

    /**
     * @return string
     */
    public function getInstallmentsAmount()
    {
        // get product
        $product = $this->registry->registry('product');

        // set if final price is exist
        if ($price = $product->getFinalPrice()) {
            return $this->currency->getCurrencySymbol() . number_format($price / 4, 2);
        }
    }

    /**
     * @return bool
     */
    public function canShow()
    {
        // check if payment is active
        if (!$this->_getPaymentIsActive()) {
            return false;
        } else {
            $excluded_categories = $this->afterpayConfig->getExcludeCategories();
            if ($excluded_categories != "") {
                $product = $this->registry->registry('product');
                $categoryids = $product->getCategoryIds();
                foreach ($categoryids as $k) {
                    if (in_array($k, $excluded_categories)) {
                        return false;
                    }
                }
            }
            return true;
        }
    }
    /**
     * @return bool
     */
    public function isProductEligible(){

        $product = $this->registry->registry('product');
        if ($product->getFinalPrice() > $this->afterpayConfig->getMaxOrderTotal() // greater than max order limit
            || $product->getFinalPrice() < $this->afterpayConfig->getMinOrderTotal()) { // lower than min order limit
            return false;
        }
        return true;
    }

    /**
     * Calculate region specific Instalment Text
     * @return string
     */
    public function getInstalmentText()
    {
        $currencyCode = $this->afterpayConfig->getMerchantCurrency();
        $assetsPath = $this->componentRegistrar->getPath(ComponentRegistrar::MODULE, 'Overdose_Afterpay');
        $assets_product_page = [];
        if(file_exists($assetsPath.'/assets.ini'))
        {
            $assets = parse_ini_file($assetsPath.'/assets.ini',true);
            if(isset($assets[$currencyCode]['product_page1']))
            {
                $assets_product_page['snippet1'] = $assets[$currencyCode]['product_page1'];
                if($this->getTypeOfProduct()=="bundle"){
                    $assets_product_page['snippet1'] = $assets[$currencyCode]['product_page_from'];
                }
                $assets_product_page['snippet2'] = $assets[$currencyCode]['product_page2'];
            } else {
                $assets_product_page['snippet1'] = '';
                $assets_product_page['snippet2'] = '';
            }
        }
        return $assets_product_page;
    }


    /**
     * @return float
     */
    public function getMaxOrderLimit()
    {
        return $this->afterpayConfig->getMaxOrderTotal();
    }

    /**
     * @return float
     */
    public function getMinOrderLimit()
    {
        return $this->afterpayConfig->getMinOrderTotal();
    }

    /**
     * @return string
     */
    public function getTypeOfProduct()
    {
        $product = $this->registry->registry('product');
        return $product->getTypeId();
    }
}
