<?php

namespace Overdose\InventoryShipping\Model\ResourceModel;

use Magento\Framework\App\ResourceConnection;
use Magento\InventoryReservationsApi\Model\ReservationInterface;

class GetReservationsForInvoice
{
    /**
     * @var ResourceConnection
     */
    private ResourceConnection $resource;

    /**
     * GetReservationsForInvoice constructor.
     * @param ResourceConnection $resource
     */
    public function __construct(
        ResourceConnection $resource
    ) {
        $this->resource = $resource;
    }

    /**
     * Get reservations for invoice
     *
     * @param string $orderId
     * @return array
     */
    public function execute(string $orderId): array
    {
        $connection = $this->resource->getConnection();
        $reservationTable = $this->resource->getTableName('inventory_reservation');
        $event = 'invoice_created';
        $select = $connection->select()
            ->from($reservationTable)
            ->where(ReservationInterface::METADATA . ' LIKE ?', '%' . $orderId . '%')
            ->where(ReservationInterface::METADATA . ' LIKE ?', '%' . $event . '%');
        return $connection->fetchAll($select);
    }
}
