<?php
namespace Overdose\LiveChat\Block;

use Magento\Framework\App\ObjectManager;
use \Magento\Framework\View\Element\Template;


class Tracking extends \Magento\Checkout\Block\Onepage\Success
{

    protected $configHelper;

    protected $order;

    /**
     * Tracking constructor.
     * @param Template\Context $context
     * @param \Magento\Checkout\Model\Session $checkoutSession
     * @param \Magento\Sales\Model\Order\Config $orderConfig
     * @param \Magento\Framework\App\Http\Context $httpContext
     * @param \Overdose\LiveChat\Helper\Config $configHelper
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Magento\Checkout\Model\Session $checkoutSession,
        \Magento\Sales\Model\Order\Config $orderConfig,
        \Magento\Framework\App\Http\Context $httpContext,
        \Overdose\LiveChat\Helper\Config $configHelper,
        array $data = []
    ) {
        $this->configHelper = $configHelper;

        parent::__construct($context, $checkoutSession, $orderConfig, $httpContext, $data);
    }

    /**
     * @return bool
     */
    public function isEnabled()
    {
        return $this->configHelper->isEnabled();
    }

    /**
     * @return bool
     */
    public function getLicense()
    {
        return $this->configHelper->getLicense();
    }

    /**
     * @return \Magento\Sales\Model\Order
     */
    protected function getOrder()
    {
        return $this->_checkoutSession->getLastRealOrder();
    }

    /**
     * Get order reference
     *
     * @return string
     */
    public function getOrderReference()
    {
        return $this->getOrder()->getIncrementId();
    }

    /**
     * Get total order value
     *
     * @return float
     */
    public function getOrderValue()
    {
        // order discount is a negative number hence the addition
        return ($this->getOrder()->getSubtotal() + $this->getOrder()->getDiscountAmount());
    }
}

