define([
    'jquery',
], function($){
    return function (config, element) {

        function initProductDescriptionOverflow() {
            var productDescriptionHeight = productDescriptionElement.clientHeight;
            if(productDescriptionHeight > 200){
                //init overflow
                productDescriptionWrapper.classList.add('page-main-description__content__description-wrapper--overflow');
                productDescriptionWrapper.classList.add('page-main-description__content__description-wrapper--show-more');
                productDescriptionWrapper.classList.remove('page-main-description__content__description-wrapper--show-less');
                productDescriptionWrapper.style.maxHeight = null;
            }
            else {
                //remove overflow
                productDescriptionWrapper.classList.remove('page-main-description__content__description-wrapper--overflow');
                productDescriptionWrapper.classList.remove('page-main-description__content__description-wrapper--show-more');
                productDescriptionWrapper.classList.remove('page-main-description__content__description-wrapper--show-less');
                productDescriptionWrapper.style.maxHeight = null;
            }
        }

        function openProductDescription(e) {
            var productDescriptionHeight = productDescriptionElement.clientHeight;
            productDescriptionWrapper.style.maxHeight = productDescriptionHeight + 'px';
            productDescriptionWrapper.classList.remove('page-main-description__content__description-wrapper--show-more');
            productDescriptionWrapper.classList.add('page-main-description__content__description-wrapper--show-less');
        }

        function closeProductDescription(e) {
            productDescriptionWrapper.style.maxHeight = null;
            productDescriptionWrapper.classList.add('page-main-description__content__description-wrapper--show-more');
            productDescriptionWrapper.classList.remove('page-main-description__content__description-wrapper--show-less');
        }

        var productDescriptionWrapper = element;
        var productDescriptionWrapperReadMore = productDescriptionWrapper.nextElementSibling;
        var productDescriptionWrapperShowLess = productDescriptionWrapperReadMore.nextElementSibling;
        var productDescriptionElement = element.querySelector('.product.attribute.description');


        initProductDescriptionOverflow();

        productDescriptionWrapperReadMore.addEventListener('click', function(e){
            openProductDescription(e);
        });

        productDescriptionWrapperShowLess.addEventListener('click', function(e){
            closeProductDescription(e);
        });

        window.addEventListener('resize', function(){
            initProductDescriptionOverflow();
        });
    }
});
