define([
    'jquery',
    'Magento_Ui/js/modal/modal'
], function ($) {
    return function (config, element) {

        function openGuideModal() {
            pageWrapper.classList.add('enable-modal')
            productGuideModal.classList.add('active');
            $('body').addClass('_has-modal')
            $('.product-info-main').addClass('_position-static')
        }

        function closeGuideModal() {
            pageWrapper.classList.remove('enable-modal')
            productGuideModal.classList.remove('active');
            $('body').removeClass('_has-modal')
            $('.product-info-main').removeClass('_position-static')
        }

        function showWidthGuideContent() {
            productGuideModalContainer.classList.add('show-width');
        }

        function hideWidthGuideContent() {
            productGuideModalContainer.classList.remove('show-width');
        }

        var productDetailtSizeWidthFitGuide = element;

        var pageWrapper = document.body.querySelector('.page-wrapper');

        var triggerFitGuide = productDetailtSizeWidthFitGuide.querySelector('#triggerFitGuide');
        var triggerSizeGuide = productDetailtSizeWidthFitGuide.querySelector('#triggerSizeGuide');
        var triggerWidthGuide = productDetailtSizeWidthFitGuide.querySelector('#triggerWidthGuide');

        var productGuideModal = productDetailtSizeWidthFitGuide.querySelector('#productGuideModal');
        var productGuideModalOverlay = productDetailtSizeWidthFitGuide.querySelector('#productGuideModalOverlay');
        var productGuideModalCloseIcon = productDetailtSizeWidthFitGuide.querySelector('#productGuideModalCloseIcon');

        var productGuideModalContainer = productDetailtSizeWidthFitGuide.querySelector('#productGuideModalContainer');
        var productGuideSizeTab = productDetailtSizeWidthFitGuide.querySelector('#productGuideSizeTab');
        var productGuideWidthTab = productDetailtSizeWidthFitGuide.querySelector('#productGuideWidthTab');


        if (triggerFitGuide) {
            triggerFitGuide.addEventListener('click', function () {
                openGuideModal();
            });
        }

        if (triggerSizeGuide) {
            triggerSizeGuide.addEventListener('click', function () {
                openGuideModal();
            });
        }

        if (triggerWidthGuide) {
            triggerWidthGuide.addEventListener('click', function () {
                openGuideModal();
                showWidthGuideContent();
            });
        }

        productGuideModalOverlay.addEventListener('click', function () {
            closeGuideModal();
        });

        productGuideModalCloseIcon.addEventListener('click', function () {
            closeGuideModal();
        });

        if (productGuideSizeTab) {
            productGuideSizeTab.addEventListener('click', function () {
                hideWidthGuideContent();
            });
        }

        if (productGuideWidthTab) {
            productGuideWidthTab.addEventListener('click', function () {
                showWidthGuideContent();
            });
        }

    }
});
