define([
    'Magento_Checkout/js/model/quote'
],
function (
    quote,
) {
    'use strict';

    var mixin = {
         initialize: function() {
             this._super();

             quote.shippingMethod.subscribe(function(newMethod) {
                 if (!newMethod) {
                     return;
                 }
                 if (newMethod['carrier_code'] == 'instore') {
                     this.isAddressSameAsShipping(false);
                 }
             }, this);
         }
    };
    
    return function (target) {
        return target.extend(mixin);
    };
});
