define([
    'jquery',
], function ($) {
    return function (config, element) {
        var pageScrollTopButton = element;
        var $pageScrollTopButton = $(element);

        var showPageScrollTopThreshold = 250;

        function checkPageScrollTop(){
            if(window.scrollY > showPageScrollTopThreshold){
                pageScrollTopButton.classList.add('active');
            }
            else {
                pageScrollTopButton.classList.remove('active');
            }
        }

        checkPageScrollTop();
        window.addEventListener('scroll', function(){
            checkPageScrollTop();
        });

        $pageScrollTopButton.click(function () {
            $("html, body").animate({ scrollTop: 0 }, 300);
            return false;
        });
    }
});
