<?php
/**
 * Copyright © Overdose Digital. All rights reserved.
 */
namespace BrittainWynyard\GoogleTagManager\Block;

/**
 * Model list provider in JSON format.
 *
 * @api
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 * @since 100.0.2
 */
class ListJson extends \Magento\GoogleTagManager\Block\ListJson
{
    /**
     * @var \BrittainWynyard\GoogleTagManager\Helper\Data
     */
    protected $bwHelper;

    /**
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param \Magento\GoogleTagManager\Helper\Data $helper
     * @param \Magento\Framework\Json\Helper\Data $jsonHelper
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Checkout\Model\Session $checkoutSession
     * @param \Magento\Customer\Model\Session $customerSession
     * @param \Magento\Checkout\Helper\Cart $checkoutCart
     * @param \Magento\Catalog\Model\Layer\Resolver $layerResolver
     * @param \Magento\Framework\Module\Manager $moduleManager
     * @param \Magento\Framework\App\Request\Http $request
     * @param \Magento\Banner\Model\ResourceModel\Banner\CollectionFactory $bannerColFactory
     * @param \Magento\GoogleTagManager\Model\Banner\Collector $bannerCollector
     * @param \BrittainWynyard\GoogleTagManager\Helper\Data $bwHelper
     * @param array $data
     *
     * @SuppressWarnings(PHPMD.ExcessiveParameterList)
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Magento\GoogleTagManager\Helper\Data $helper,
        \Magento\Framework\Json\Helper\Data $jsonHelper,
        \Magento\Framework\Registry $registry,
        \Magento\Checkout\Model\Session $checkoutSession,
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Checkout\Helper\Cart $checkoutCart,
        \Magento\Catalog\Model\Layer\Resolver $layerResolver,
        \Magento\Framework\Module\Manager $moduleManager,
        \Magento\Framework\App\Request\Http $request,
        \Magento\Banner\Model\ResourceModel\Banner\CollectionFactory $bannerColFactory,
        \Magento\GoogleTagManager\Model\Banner\Collector $bannerCollector,
        \BrittainWynyard\GoogleTagManager\Helper\Data $bwHelper,
        array $data = []
    ) {
        $this->bwHelper = $bwHelper;
        parent::__construct(
            $context,
            $helper,
            $jsonHelper,
            $registry,
            $checkoutSession,
            $customerSession,
            $checkoutCart,
            $layerResolver,
            $moduleManager,
            $request,
            $bannerColFactory,
            $bannerCollector,
            $data
        );
    }

    /**
     * Format product item for output to json
     *
     * @param \Magento\Quote\Model\Quote\Item $item
     * @return array
     */
    protected function _formatProduct($item)
    {
        $product = [];
        $product['id'] = $item->getSku();
        $product['name'] = $item->getName();
        $product['price'] = $item->getPriceInclTax(); // changed from $item->getPrice()
        $product['qty'] = $item->getQty();
        $parentItem = $item->getParentItem();
        if ($parentItem) {
            $item = $parentItem;
        }
        $productId  = $item->getProduct()->getId();
        $product['brand'] = $this->bwHelper->getProductAttributeValueByCode($productId, 'brand');
        $product['category'] = $this->bwHelper->getProductAttributeValueByCode($productId, 'ga_category');

        return $product;
    }
}
