<?php

namespace BrittainWynyard\Sales\Observer;

use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;

class OrderPlaceAfter implements ObserverInterface
{


    /**
     * set suburb to empty for the C&C order's shipping address
     *
     * @param EventObserver $observer
     */
    public function execute(EventObserver $observer)
    {
        /** @var \Magento\Sales\Api\Data\OrderInterface $order */
        $order = $observer->getOrder();

        if (!$order) {
            return;
        }

        if ($order->getShippingMethod() == 'instore_pickup') {  
           /** @var $shippingExtensionAttributes \Magento\Sales\Api\Data\OrderExtension */
           $shippingAddress = $order->getShippingAddress();
           $shippingAddress->setSuburb('')->save();
        }
    }
}
