<?php
namespace Overdose\Cart\Controller\Cart;

use Magento\Framework\App\Action\HttpPostActionInterface;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\Result\JsonFactory;
use Overdose\Catalog\Helper\Stock as StockHelper;

class GetSaleableQty implements HttpPostActionInterface
{
    private const MAX_QTY = 10;
    private const DEFAULT_QTY = 10;

    public function __construct(
        /** @promote */ private RequestInterface $request,
        /** @promote */ private JsonFactory $resultJsonFactory,
        /** @promote */ private StockHelper $stockHelper
    ) {}

    public function execute()
    {
        $result = $this->resultJsonFactory->create();
        $sku = $this->request->getParam('sku');

        // Validate SKU
        if (!$sku || !is_string($sku)) {
            return $result->setData([
                'success' => false,
                'max_qty' => self::MAX_QTY,
                'error' => 'Invalid product SKU'
            ]);
        }

        try {
            $saleableQty = $this->stockHelper->getSaleableStock($sku);

            // Limit to maximum
            $maxQty = min($saleableQty, self::MAX_QTY);

            return $result->setData([
                'success' => true,
                'max_qty' => $maxQty,
                'saleable_qty' => $saleableQty
            ]);
        } catch (\Exception $e) {
            return $result->setData([
                'success' => false,
                'max_qty' => self::MAX_QTY,
                'saleable_qty' => self::DEFAULT_QTY,
                'error' => $e->getMessage()
            ]);
        }
    }
}