<?php

namespace Overdose\CatalogAttribute\Plugin\Model;

use Magento\Catalog\Model\Product;
use Magento\Eav\Model\Config;

class ConfigurableAttributeData
{
    /**
     * @var Config
     */
    protected $eavConfig;

    /**
     * @param Config $eavConfig
     */
    public function __construct(Config $eavConfig)
    {
        $this->eavConfig = $eavConfig;
    }

    /**
     * @param $subject
     * @param $result
     * @param $product
     * @param $options
     * @return array
     */
    public function afterGetAttributesData($subject, $result, $product, $options)
    {
        try {
            foreach ($result as $type => $value) {
                if ($type == 'attributes') {
                    foreach ($value as $attributeId => $attributeData) {
                        if (isset($attributeData['code']) && $attributeData['code'] == 'size') {
                            $result[$type][$attributeId]['label'] = $attributeData['label'] . ':';
                            if ($product->getAsicsSizeLabel()) {
                                $attribute = $this->eavConfig->getAttribute('catalog_product', 'asics_size_label');
                                $options = $attribute->getSource()->getAllOptions();
                                foreach ($options as $option) {
                                    if ($option['value'] == $product->getAsicsSizeLabel()) {
                                        $result[$type][$attributeId]['label'] = $option['label'];
                                        break;
                                    }
                                }
                            } else {
                                $result[$type][$attributeId]['label'] = $attributeData['label'] . ':';
                            }
                            break;
                        }
                    }
                }
            }
        } catch (\Exception $e) {

        }

        return $result;
    }
}
