<?php

namespace Overdose\DataLayer\Plugin;

/**
 * Class CheckoutReload
 * @package Overdose\DataLayer\Plugin
 */
class CheckoutReload extends GenericPlugin
{
    public function afterDispatch($subject, $result)
    {
        $quote = $this->session->getQuote();
        if ($quote && $quote->getCustomerEmail()) {
            $customerEmail = strtolower($quote->getCustomerEmail());
            $this->cookiesHelper->setDataLayerCookieUserIdentify($customerEmail);
        }
        return $result;
    }
}
