<?php

namespace Overdose\DataLayer\Plugin;

use BrittainWynyard\OneAsics\Controller\Login\Index;
use Magento\Customer\Model\Customer;

class CustomerCreateOneAsics extends GenericPlugin
{
    public function afterCreateNewCustomer(Index $subject, Customer $result): Customer
    {
        $customerEmail = '';
        $event = 'account_creation';
        $identification_location = 'account_creation_site';
        if (str_contains($this->redirect->getRefererUrl(), self::SUCCESSPAGE_KEY)) {
            $identification_location = 'account_creation_successpage';
        }

        if ($result->getEmail()) {
            $customerEmail = strtolower($result->getEmail());
        }

        $this->cookiesHelper->setDataLayerCookieUserIdentify($customerEmail);
        $this->cookiesHelper->setDataLayerCookie($event, $identification_location);
        return $result;
    }
}
