<?php

namespace Overdose\OrderComment\Plugin\Block\Adminhtml;

use Magento\Framework\Exception\LocalizedException;
use Magento\Sales\Block\Adminhtml\Order\View\Info;
use Overdose\OrderComment\Model\Data\OrderComment;

class SalesOrderViewInfo
{
    /**
     * @param Info $subject
     * @param string $result
     * @return string
     * @throws LocalizedException
     */
    public function afterToHtml(
        Info $subject,
        $result
    ) {
        $commentBlock = $subject->getLayout()->getBlock('checkout_order_comments');
        if ($commentBlock !== false && $subject->getNameInLayout() == 'order_info') {
            $commentBlock->setOrderComment($subject->getOrder()->getData(OrderComment::COMMENT_FIELD_NAME));
            $result = $result . $commentBlock->toHtml();
        }
        
        return $result;
    }
}
