<?php

namespace Verifone\Hosted\Controller\Standard;

class Redirect extends \Verifone\Hosted\Controller\Checkout
{
    /**
     * @return \Magento\Framework\App\ResponseInterface|\Magento\Framework\Controller\Result\Json|\Magento\Framework\Controller\ResultInterface
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function execute()
    {
        if (! $this->getRequest()->isAjax()) {
            $this->_cancelPayment();
            $this->_checkoutSession->restoreQuote();
            $this->getResponse()->setRedirect(
                $this->getCheckoutHelper()->getUrl('checkout')
            );
        } else {

            $paymentMethod = $this->getPaymentMethod();
            $this->getCheckoutHelper()->setUpVerifoneSettings($paymentMethod);
            if ($this->getCheckoutHelper()->getVerifoneSettings()->isOrderBeforeRedirect()) {
                $order = $this->getOrder();
                $quote = $this->_quoteRepository->get($order->getQuoteId());
            } else {
                $quote = $this->getQuote();
                $email = $this->getRequest()->getParam('email');
                $this->getCheckoutHelper()->setUpVerifoneSettings($paymentMethod);
                $quote->setCustomerEmail($email);

                if (!$quote->getReservedOrderId()) {
                    $quote->reserveOrderId();
                }

                $this->getCheckoutSession()->loadCustomerQuote();
                if (!$this->getCustomerSession()->isLoggedIn()) {
                    $quote->setCheckoutMethod(\Magento\Checkout\Model\Type\Onepage::METHOD_GUEST);
                } else {
                    $quote->updateCustomerData($this->getQuote()->getCustomer());
                    $quote->setCheckoutMethod(\Magento\Checkout\Model\Type\Onepage::METHOD_CUSTOMER);
                }

                $this->_quoteRepository->save($quote);
            }

            $params = [];
            $params['result'] = 'failed';

            try {
                $result = $this->getCheckoutHelper()->processPayment($paymentMethod, $quote);
            } catch (\Exception $e) {
                $this->_logger->info($e->getMessage());
                $this->_logger->info($e->getTraceAsString());
                $params['messages'] = "An unexpected error occurred. Please retry the payment. No money has been charged.";
            }

            if (isset($result['url']) && isset($result['method']) && $result['method'] == "iframe") {
                $params['result'] = 'success';
                $params['method'] = $result['method'];
                $params['url'] = $result['url'];
            }

            if (isset($result['redirect']) && isset($result['method']) && $result['method'] == "hpp") {
                $params['result'] = 'success';
                $params['method'] = $result['method'];
                $params['redirect'] = $result['redirect'];
            }

            return $this->_resultJsonFactory->create()->setData($params);
        }
    }
}
