<?php

namespace Verifone\Hosted\Model;

use VerifoneEcomAPI\ApiWrapper\Settings;

/**
 * @api
 * @since 100.0.2
 */
class TransactionType implements \Magento\Framework\Option\ArrayInterface
{
    /**
     * @return array|array[]
     */
    public function toOptionArray()
    {
        return [
            ['value' => Settings::TRANSACTION_TYPE_PRE_AUTH, 'label' => __('Pre-auth')],
            ['value' => Settings::TRANSACTION_TYPE_AUTH, 'label' => __('Auth')],
            ['value' => Settings::TRANSACTION_TYPE_SALE, 'label' => __('Sale')]];
    }

    /**
     * @return array
     */
    public function toArray()
    {
        return [Settings::TRANSACTION_TYPE_PRE_AUTH => __('Pre-auth'), Settings::TRANSACTION_TYPE_AUTH => __('Auth'), Settings::TRANSACTION_TYPE_SALE => __('Sale')];
    }
}
