define([
    'jquery',
    'Magento_Ui/js/modal/modal',
    'jquery-ui-modules/widget'
], function ($, modal) {
    'use strict';

    $.widget('od.afterpayCartModal', {
        _create: function () {
            this.initCartModal();
        },

        initCartModal: function () {
            const cartPopup = $('#afterpay-cart-modal-popup');
            const options = {
                responsive: false,
                innerScroll: false,
                modalClass: 'afterpay-learn-more'
            };

            modal(options, cartPopup);

            const _triger = $(this.element);

            if (_triger.length) {
                _triger.on("click", function () {
                    $("#afterpay-cart-modal-popup .afterpay-cart-modal-image").attr({
                        'src': "https://static.afterpay.com/lightbox-desktop.png",
                        'srcset': "https://static.afterpay.com/lightbox-desktop.png 1x,https://static.afterpay.com/lightbox-desktop@2x.png 2x,https://static.afterpay.com/lightbox-desktop@3x.png 3x"
                    });

                    cartPopup.show();
                    cartPopup.modal('openModal');
                });
            }
        }
    });

    return $.od.afterpayCartModal;
});
