define([
    'helper/overlay',
    'jquery',
    'jquery-ui-modules/core',
    'jquery-ui-modules/widget',
    'mage/dropdown'
], function (overlay, $) {
    'use strict';

    $.widget('od.dropdownDialog', $.mage.dropdownDialog, {
        options: {
            accountPopupClass: '.showaccount',
            registerPopupClass: '.showregister',
        },

        open: function () {
            this._super();
            if((this.options.triggerTarget === this.options.accountPopupClass) || (this.options.triggerTarget === this.options.registerPopupClass)) {
                overlay.show('header.page-header', 'theme-overlay');
                $('body').addClass('active-header');
            }
        },

        close: function () {
            this._super();
            if((this.options.triggerTarget === this.options.accountPopupClass) || (this.options.triggerTarget === this.options.registerPopupClass)) {
                overlay.hide('theme-overlay');
                $('body').removeClass('active-header');
            }
        }
    });

    return $.od.dropdownDialog;
});
