/**
 * Reset currentBillingAddress data because "placeOrder" method clear "checkout-data" and display not correct data.
 */
define([
    'jquery',
    'mage/utils/wrapper',
    'Magento_Customer/js/customer-data'
], function ($, wrapper, customerData) {
    'use strict';

    return function (placeOrder) {
        return wrapper.wrap(placeOrder, function (originalAction, serviceUrl, payload, messageContainer) {

            if (payload.paymentMethod.method == 'windcave_pxpay2_iframe') {
                let result,
                    dataBeforeClear = customerData.get('checkout-data')();

                $.when(
                    result = originalAction(serviceUrl, payload, messageContainer)
                ).done(function () {
                    customerData.set('checkout-data', dataBeforeClear);
                });
                return result;
            }

            //No PxPay, just sending the request
            return originalAction(serviceUrl, payload, messageContainer);
        });
    };
});
